define(['modules/new-appointment-request/resources/common/method/model'], function(Model) {
    'use strict';

    var METHOD = 'scheduling-method';

    describe('Scheduling Method Model', function() {
        var model;

        beforeEach(function() {
            model = new Model();
        });

        it('sets direct correctly', function() {
            model.setDirect();
            expect(model.get(METHOD)).toBe('direct');
        });

        it('sets requests correctly', function() {
            model.setRequest();
            expect(model.get(METHOD)).toBe('clerk');
        });

        it('checks direct correct', function() {
            model.setDirect();
            expect(model.isDirect()).toBeTruthy();
            expect(model.isRequest()).toBeFalsy();
        });

        it('checks request correct', function() {
            model.setRequest();
            expect(model.isDirect()).toBeFalsy();
            expect(model.isRequest()).toBeTruthy();
        });
    });
});
